// Copyright (c) 2019 Israel.
// All rights reserved to Tel Aviv University.
//
// This file is private property of Tel Aviv University.
//
// Author(s): Nir Goren         <nirgoren@mail.tau.ac.il>
//            Efi Fogel         <efifogel@gmail.com>

#ifndef CGALPY_CONFIG_HPP
#define CGALPY_CONFIG_HPP

#define CGAL_HEADER_ONLY 1

#define CGALPY_EPEC_KERNEL 0
#define CGALPY_EPIC_KERNEL 1

#ifndef CGALPY_KERNEL
#define CGALPY_KERNEL 0
#endif

#define CGALPY_DEFAULT_DCEL 0
#define CGALPY_FACE_EXTENDED_DCEL 1
#define CGALPY_EXTENDED_DCEL 4

#ifndef CGALPY_DCEL
#define CGALPY_DCEL 2
#endif

#define CGALPY_ARR_LINEAR_TRAITS 0
#define CGALPY_ARR_SEGMENT_TRAITS 1
#define CGALPY_ARR_NON_CACHING_SEGMENT_TRAITS 2
#define CGALPY_ARR_CONIC_TRAITS 3
#define CGALPY_ARR_ALGEBRAIC_SEGMENT_TRAITS 4
#define CGALPY_ARR_CIRCLE_SEGMENT_TRAITS 5

#ifndef CGALPY_GEOMETRY_TRAITS
#define CGALPY_GEOMETRY_TRAITS 1
#endif

#ifndef CGALPY_DIMENSION
#define CGALPY_DIMENSION 4
#endif

#if CGALPY_KERNEL == CGALPY_EPEC_KERNEL
#define CGALPY_KERNEL_SHORT_NAME epec
#elif CGALPY_KERNEL == CGALPY_EPIC_KERNEL
#define CGALPY_KERNEL_SHORT_NAME epic
#endif

#if CGALPY_GEOMETRY_TRAITS == CGALPY_ARR_LINEAR_TRAITS
#define CGALPY_GEOMETRY_TRAITS_SHORT_NAME linear
#elif CGALPY_GEOMETRY_TRAITS == CGALPY_ARR_SEGMENT_TRAITS
#define CGALPY_GEOMETRY_TRAITS_SHORT_NAME seg
#elif CGALPY_GEOMETRY_TRAITS == CGALPY_ARR_NON_CACHING_SEGMENT_TRAITS
#define CGALPY_GEOMETRY_TRAITS_SHORT_NAME ncseg
#elif CGALPY_GEOMETRY_TRAITS == CGALPY_ARR_CONIC_TRAITS
#define CGALPY_GEOMETRY_TRAITS_SHORT_NAME conic
#elif CGALPY_GEOMETRY_TRAITS == CGALPY_ARR_ALGEBRAIC_SEGMENT_TRAITS
#define CGALPY_GEOMETRY_TRAITS_SHORT_NAME alg
#elif CGALPY_GEOMETRY_TRAITS == CGALPY_ARR_CIRCLE_SEGMENT_TRAITS
#define CGALPY_GEOMETRY_TRAITS_SHORT_NAME cs
#endif

#define CONCAT_3(a, b, c) a ## _ ## b ## _ ## c
#define SET_MODULE_NAME(a, b, c) CONCAT_3(a, b, c)

#define CONCAT_4(a, b, c, d) a ## _ ## b ## _ ## c ## _ ## d
#define SET_MODULE_NAME_EX(a, b, c, d) CONCAT_4(a, b, c, d)

#if CGALPY_DCEL == CGALPY_DEFAULT_DCEL
#define CGALPY_MODULE_NAME SET_MODULE_NAME(arr2, CGALPY_KERNEL_SHORT_NAME, CGALPY_GEOMETRY_TRAITS_SHORT_NAME)
#endif
#if CGALPY_DCEL == CGALPY_FACE_EXTENDED_DCEL
#define CGALPY_MODULE_NAME SET_MODULE_NAME_EX(arr2, CGALPY_KERNEL_SHORT_NAME, CGALPY_GEOMETRY_TRAITS_SHORT_NAME, fex)
#endif
#if CGALPY_DCEL == CGALPY_EXTENDED_DCEL
#define CGALPY_MODULE_NAME SET_MODULE_NAME_EX(arr2, CGALPY_KERNEL_SHORT_NAME, CGALPY_GEOMETRY_TRAITS_SHORT_NAME, ex)
#endif

#endif //CONFIG_HPP
